<?php

/**
 * Varnish purge object
 */

/**
 * Class W3_Varnish
 */
class W3_Varnish {
    /**
     * Debug flag
     *
     * @var bool
     */
    var $_debug = false;

    /**
     * Varnish servers
     *
     * @var array
     */
    var $_servers = array();

    /**
     * Operation timeout
     *
     * @var int
     */
    var $_timeout = 30;

    /**
     * PHP5-style constructor
     */
    function __construct() {
        $config = & w3_instance('W3_Config');

        $this->_debug = $config->get_boolean('varnish.debug');
        $this->_servers = $config->get_array('varnish.servers');
        $this->_timeout = $config->get_integer('timelimit.varnish_purge');
    }

    /**
     * PHP4-style constructor
     */
    function W3_Varnish() {
        $this->__construct();
    }

    /**
     * Purge URIs (Bernews)
     *
     * @param string $uris
     * @return boolean
     */
    function purge($uris) {
        require_once W3TC_INC_DIR . '/functions/http.php';

        $success = true;
        foreach ($uris as $uri) {        
            @set_time_limit($this->_timeout);        

            if (strpos($uri, '/') !== 0) {
                $uri = '/' . $uri;
            }

            foreach ((array) $this->_servers as $server) {
                $response = $this->request_purge($server, $uri);

                if (is_wp_error($response)) {
                    $this->_log($uri, sprintf('Unable to send request: %s.', implode('; ', $response->get_error_messages())));

                    $success = false;
                }

                if ($response['response']['code'] !== 200) {
                    $this->_log($uri, 'Bad response code.');

                    $success = false;
                }

                $this->_log($uri, 'OK');
            }
        }

        // Bernews
        foreach ((array) $this->_servers as $server) {
            $this->_recache_purged_pages($server, $uris);
        }
    
        return $success;
    }
    
    /** 
     * Bernews: Sends purge request. Cannt use default wp HTTP implementation
     * if we send request to different host than specified in $url
     * 
     * @param $uri string
     */
    function request_purge($varnish_server, $uri) {
        if (strpos($varnish_server, ':'))
            list($varnish_host, $varnish_port) = explode(':', $varnish_server);
        else {
            $varnish_host = $varnish_server;
            $varnish_port = 80;
        }
        
        $host = 'bernews.com';
        
        $request_headers_array = array(
            sprintf('PURGE %s HTTP/1.1', $uri),
            sprintf('User-Agent: %s', W3TC_POWERED_BY),
            sprintf('Host: %s', $host),
            'Connection: close'
        );

        $request_headers = implode("\r\n", $request_headers_array);
        $request = $request_headers . "\r\n\r\n";

        // log what we are about to do
        $this->_log($uri, sprintf('Connecting to %s ...', $varnish_host));
        $this->_log($uri, sprintf('PURGE %s HTTP/1.1', $uri));
        $this->_log($uri, sprintf('Host: %s', $host));
        
        $errno = null;
        $errstr = null;
        $fp = @fsockopen($varnish_host, $varnish_port, $errno, $errstr, 10);
        if (!$fp)
            return new WP_Error('http_request_failed', $errno . ': ' . $errstr);

        @stream_set_timeout($fp, 60);

        @fputs($fp, $request);

        $response = '';
        while (!@feof($fp))
            $response .= @fgets($fp, 4096);

        @fclose($fp);

        list($response_headers, $contents) = explode("\r\n\r\n", $response, 2);
        $matches = null;
        if (preg_match('~^HTTP/1.[01] (\d+)~', $response_headers, $matches)) {
            $status = (int)$matches[1];
            $return = array(
                'response' => array(
                    'code' => $status));
            return $return;
        }

        return new WP_Error('http_request_failed', 
            'Unrecognized response header' . $response_headers);
    }    

    /** 
     * Bernews: Recache purged URLs by starting an async curl.
     */
    function _recache_purged_pages($varnish_server, $uris) {
        $command = '/usr/bin/curl --user-agent W3TC_VARNISH_REFRESH --header "Host: bernews.com" --header "Accept-Encoding: gzip" --connect-timeout 2 --max-time 10 --silent --location ';
        foreach ($uris as $uri) {
            $command .= sprintf('http://%s%s ', $varnish_server, $uri);
        }
        $command .= '> /dev/null 2>/dev/null &';
        @file_put_contents(W3TC_VARNISH_LOG_FILE, $command, FILE_APPEND);
        shell_exec($command);
    }

    /**
     * Write log entry
     *
     * @param string $url
     * @param string $error
     * @return bool|int
     */
    function _log($url, $error) {
        if ($this->_debug) {
            $data = sprintf("[%s] [%s] %s\n", date('r'), $url, $error);

            return @file_put_contents(W3TC_VARNISH_LOG_FILE, $data, FILE_APPEND);
        }

        return true;
    }
}
